#!/usr/bin/perl

=head1
FindFile.pm

=head2
DESCRIPTION

FindFile.pm     Finds a file on a path symbol; returns full filename
or an empty string if the file was not found.

=head2
USAGE

   $name = &findfile (filename, path_symbol);

   e.g.    $filename = &findfile ("myfile.c", "PATH");

=head2
CREDITS

   Written:    97/05/01   Pieter Hintjens <ph@imatix.com>
   Revised:    97/05/02   Pieter Hintjens <ph@imatix.com>
   Converted to Perl 5.005_03 14/07/01 Kathryn Andersen <kat@foobox.net>

=cut

package FindFile;
require 5.005_03;
use strict;
use Exporter;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $revision $VERSION);

@ISA         = qw(Exporter);
@EXPORT      = qw(findfile);

$revision    = q$Id: FindFile.pm,v 1.1 2001/07/18 14:25:08 kat Exp $;
$VERSION     = "1.01";

sub findfile ($$) {
    my ($filename, $path) = @_;
    my (@path_table);

    #   Split path differently on MS-DOS and UNIX (ugh!)
    @path_table = split (defined ($ENV {"COMSPEC"})? ";": ":", $ENV {$path});

    #   If file has absolute path, or exists locally, that's fine for us
    return $filename if -f $filename;
    foreach (@path_table) {
        return "$_/$filename" if -f "$_/$filename";
    }
    return "";
}

#######################################################################
# End of subroutines

1;

