#!/usr/bin/perl
=head1
ShellWords.pm

=head2
USAGE

      require ShellWords;
      @words = &shellwords($line);
      or
      @words = &shellwords(@lines);
      or
      @words = &shellwords;           # defaults to $_ (and clobbers it)

=head2
CREDITS

   Converted to Perl 5.005_03 16/07/01 Kathryn Andersen <kat@foobox.net>

=cut

package ShellWords;
require 5.005_03;
use strict;
use Exporter;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $revision $VERSION);

@ISA         = qw(Exporter);
@EXPORT      = qw(shellwords);

$revision    = q$Id: ShellWords.pm,v 1.1 2001/07/18 14:25:08 kat Exp $;
$VERSION     = "1.01";

sub shellwords {
    local($_) = join('', @_) if @_;
    my(@words,$snippet,$field);

    s/^\s+//;
    while ($_ ne '') {
        $field = '';
        for (;;) {
            if (s/^"(([^"\\]|\\.)*)"//) {
                ($snippet = $1) =~ s#\\(.)#$1#g;
            }
            elsif (s/^"(([^"\\]|\\.)*)//) {
                ($snippet = $1) =~ s#\\(.)#$1#g;
            }
            elsif (s/^'(([^'\\]|\\.)*)'//) {
                ($snippet = $1) =~ s#\\(.)#$1#g;
            }
            elsif (s/^'(([^'\\]|\\.)*)//) {
                ($snippet = $1) =~ s#\\(.)#$1#g;
            }
            elsif (s/^\\(.)//) {
                $snippet = $1;
            }
            elsif (s/^([^\s\\'"]+)//) {
                $snippet = $1;
            }
            else {
                s/^\s+//;
                last;
            }
            $field .= $snippet;
        }
        push(@words, $field);
    }
    @words;
}

#######################################################################
# End of subroutines

1;

